<?php
if (!defined('_CAN_LOAD_FILES_'))
	exit;

class epochta2w extends Module
{
	private $sms_text = '{name} номер декларации - {number} по заказу #{orderid}'; 
	private $username = 'demo@example.com';
	private $password = '28BD5G3';
	private $tel      = '380999999999';
	private $operation= 'SEND';

	public function __construct()
	{
		$this->name = 'epochta2w';
		$this->displayName = 'SMS через ePochtaSMS.ru';
		$this->description = $this->l('Отправка номера отправления (tracking number) по смс');
		$this->tab = 'administration';
		$this->version = 1.0;
		$this->author = 'ePochtaSMS.ru';
		$this->need_instance = 0;
		$this->sms_text = Configuration::get('EP2W_SMS_TEXT');
		$this->username = Configuration::get('EP2W_LOGIN');
		$this->password = Configuration::get('EP2W_PASSWORD');
		parent::__construct();
	}
	public function install()
	{
		if (!parent::install())return false;
		Configuration::updateValue('EP2W_SMS_TEXT', '{name} номер декларации - {number} по заказу #{orderid}');
		Configuration::updateValue('EP2W_LOGIN', '');
		Configuration::updateValue('EP2W_PASSWORD', '');
		return true;
	}
	public function uninstall()
	{
		Configuration::deleteByName('EP2W_SMS_TEXT');
		Configuration::deleteByName('EP2W_LOGIN');
		Configuration::deleteByName('EP2W_PASSWORD');
		return true;
	}

public function hookSendSms($data)
{
$tel = preg_replace('/\D/','',$data[0]);
$text = $this->forXml(str_replace(
	array('{name}','{number}','{orderid}'),
	array($data[1], $data[2]->shipping_number, $data[2]->id),
	$this->sms_text));

$src = <<<END
<?xml version="1.0" encoding="UTF-8"?>
<SMS>
<operations>
<operation>{$this->operation}</operation>
</operations>
<authentification>
<username>{$this->username}</username>
<password>{$this->password}</password>
</authentification>
<message>
<sender>sms-info</sender>
<text>{$text}</text>
</message>
<numbers><number>{$tel}</number></numbers>
</SMS>
END;
$Curl = curl_init();
$CurlOptions = array(
CURLOPT_URL=>'http://atompark.com/members/sms/xml.php',
CURLOPT_FOLLOWLOCATION=>false,
CURLOPT_POST=>true,
CURLOPT_HEADER=>false,
CURLOPT_RETURNTRANSFER=>true,
CURLOPT_CONNECTTIMEOUT=>15,
CURLOPT_TIMEOUT=>100,
CURLOPT_HTTPHEADER=>array('Expect:'),
CURLOPT_POSTFIELDS=>array('XML'=>$src),
);
curl_setopt_array($Curl, $CurlOptions);
if(false === ($Result = curl_exec($Curl))) {throw new Exception('Http request failed');}
curl_close($Curl);
return print_r($Result,true);  

}

	private function forXml($str,$url = false) 
	{
		$str = preg_replace(array('/\x00/','/[\x0-\x1F]/','/\s{2,}/'),array('','-',' '),$str);
		$str = htmlspecialchars($str,ENT_QUOTES);
		if ($url) $str = preg_replace('/(\s|\t)/','%20',$str);
		return trim(mb_convert_encoding($str,'UTF-8','cp1251,UTF-8'));
	}
	public function getContent()
	{
		if (!Tools::isSubmit('btnSubmit'))
		{
			$_POST['user'] = $this->username;
			$_POST['password'] = $this->password;
			$_POST['text_sms'] = $this->sms_text;
		}
		$this->_html .= '<fieldset>
			<fieldset><legend><img src="'.$this->_path.'prefs.gif" alt="" title="" /> '.$this->l('Settings').'</legend>
			<form action="'.Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']).'" method="post">
				<label>Логин:</label>
				<div class="margin-form"><input type="text" name="user" value="'.Tools::htmlentitiesUTF8(Tools::getValue('user')).'" /></div>
				<label>Пароль:</label>
				<div class="margin-form"><input type="text" name="password" value="'.Tools::htmlentitiesUTF8(Tools::getValue('password')).'" /></div>
				<label>Текст сообщения:</label>
				<div class="margin-form"><textarea style="font-family:Courier New" name="text_sms" cols="80" rows="3">'.Tools::htmlentitiesUTF8(Tools::getValue('text_sms')).'</textarea></div>
				<div class="margin-form"><input class="button" name="btnSubmit" value="'.$this->l('Update settings').'" type="submit" /></div>
			</form>
		</fieldset>';
		if (Tools::isSubmit('btnSubmit'))
		{
			Configuration::updateValue('EP2W_SMS_TEXT', Tools::getValue('text_sms'));
			Configuration::updateValue('EP2W_LOGIN', Tools::getValue('user'));
			Configuration::updateValue('EP2W_PASSWORD', Tools::getValue('password'));
		}
		return $this->_html;
	}

}
?>